@echo off
setlocal enabledelayedexpansion

REM ================================
REM CONFIGURAZIONE
REM ================================
set "VERSION=1.4.5"
set "URL=https://sourceforge.net/projects/rustdesk.mirror/files/%VERSION%/rustdesk-%VERSION%-x86_64.exe/download"
set "FILE=rustdesk-%VERSION%-x86_64.exe"
set "LOG=%TEMP%\rustdesk_install.log"

echo [INFO] Download RustDesk v%VERSION%...
powershell -Command "(New-Object System.Net.WebClient).DownloadFile('%URL%', '%FILE%')" >>"%LOG%" 2>&1

if not exist "%FILE%" (
    echo [ERRORE] Download fallito. Controlla il log: %LOG%
    exit /b 1
)

echo [INFO] Installazione silenziosa in corso...
"%FILE%" --silent-install >>"%LOG%" 2>&1

if %ERRORLEVEL% NEQ 0 (
    echo [ERRORE] Installazione fallita. Codice: %ERRORLEVEL%
    echo Controlla il log: %LOG%
    exit /b 1
)

echo [OK] RustDesk v%VERSION% installato correttamente.


REM ================================
REM CREAZIONE ESEGUIBILE RUSTDESK CUSTOM FIRENZE UFFICIO
REM ================================
timeout /t 5 /nobreak
setlocal

set "source=C:\Program Files\RustDesk\rustdesk.exe"
set "destination=C:\Program Files\RustDesk\rustdesk-host=assistenza.firenzeufficio.it,key=B+SKV7iG2arFFbVuK2fOlApWjk4ibBq2bXCy9jOVifQ=.exe"

if exist "%source%" (
    copy /Y "%source%" "%destination%"
    if %errorlevel%==0 (
        echo File copiato correttamente in "%destination%"
    ) else (
        echo Errore durante la copia.
    )
) else (
    echo Il file sorgente non esiste: "%source%"
)

endlocal

REM ================================
REM CREAZIONE COLLEGAMENTO SUL DESKTOP
REM ================================
echo [INFO] Creazione collegamento sul desktop...

setlocal

rem Percorso del collegamento
set "DESKTOP=%USERPROFILE%\Desktop"
set "LINKNAME=Assistenza Remota.lnk"

rem Percorso eseguibile RustDesk host personalizzato
set "TARGET=C:\Program Files\RustDesk\rustdesk-host=assistenza.firenzeufficio.it,key=B+SKV7iG2arFFbVuK2fOlApWjk4ibBq2bXCy9jOVifQ=.exe"

rem Percorso icona (logo.ico nella stessa cartella dello script)
set "ICON=%~dp0logo.ico"

rem Crea collegamento tramite PowerShell
powershell -NoLogo -NoProfile -Command ^
  "$s=(New-Object -COM WScript.Shell).CreateShortcut('%DESKTOP%\%LINKNAME%');" ^
  "$s.TargetPath='%TARGET%';" ^
  "$s.IconLocation='%ICON%';" ^
  "$s.WorkingDirectory='C:\Program Files\RustDesk';" ^
  "$s.Save()"

echo Collegamento creato correttamente.
endlocal

REM ================================
REM ELIMINA COLLEGAMENTO RUSTDESK ORIGINALE SUL DESKTOP 
REM ================================


setlocal

rem Percorsi Desktop (utente corrente e Public)
set "DESK1=%USERPROFILE%\Desktop"
set "DESK2=%PUBLIC%\Desktop"

rem Cerca ed elimina qualsiasi collegamento a rustdesk.exe
for %%D in ("%DESK1%" "%DESK2%") do (
    if exist "%%D" (
        for %%L in ("%%D\RustDesk*.lnk" "%%D\rustdesk*.lnk") do (
            if exist "%%~L" (
                echo Eliminazione: %%~L
                del /f /q "%%~L"
            )
        )
    )
)

exit /b 0